# Generated by Django 2.2.6 on 2019-10-17 07:36

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('product', '0001_initial'),
        ('user', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status_order', models.CharField(choices=[('unpaid', 'Unpaid'), ('paid', 'Paid'), ('cancel', 'Cancel'), ('delete', 'Delete')], db_index=True, default='unpaid', max_length=10, verbose_name='status_order')),
                ('order_receiver_name', models.CharField(blank=True, max_length=100, verbose_name='Order Receiver Name')),
                ('order_email', models.EmailField(blank=True, max_length=100, verbose_name='Order Receiver Email')),
                ('order_telephone', models.CharField(blank=True, max_length=100, verbose_name='Order Receiver Telephone')),
                ('order_receiver_address_postal', models.CharField(blank=True, max_length=100, verbose_name='Order Receiver Address Postal')),
                ('order_receiver_address', models.CharField(blank=True, max_length=100, verbose_name='Order Receiver Address')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('braintree_id', models.CharField(blank=True, max_length=150)),
                ('owner', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='own_orders', to='user.User', verbose_name='Order Owner')),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status_delivery', models.CharField(blank=True, choices=[('un-delivery', 'Un-Delivery'), ('in delivery', 'In-Delivery'), ('delivered', 'Delivered')], db_index=True, default='un-delivery', max_length=50, verbose_name='status_delivery')),
                ('price', models.DecimalField(decimal_places=2, max_digits=10)),
                ('quantity', models.PositiveIntegerField(default=1)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orderitems', to='order.Order', verbose_name='belongsorder')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='boughtproducts', to='product.Product', verbose_name='bought_products')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
    ]
